<?php
function update_ongoing_compliance($edcomp, $prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $fpr, $approver, $hod, $location, $department, $companyid, $editorid, $editorrole){
    $complianceFound = 0;
	// Update all Compliances with the given compliance id, fpr, appr, hod, location, department with cycle id 0
	$allComplianc = getAllCompliances($edcomp, $prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $companyid); // get all the compliances for the compliance ID with due date blank
	$dueDate = array(); // collecting due dates for the generation
	$excludeDate = array(); // getting excludedate for the generation
	if(count($allComplianc)>=1){
		foreach($allComplianc as $allc){
			$old_data = "FPR:".$allc['fpr_id'].",Approver:".$allc['appr_id'].",HoD:".$allc['hod_id'].",Location:".$allc['location'].",Department:".$allc['department'];
			$new_data = "FPR:".$fpr.",Approver:".$approver.",HoD:".$hod.",Location:".$location.",Department:".$department;
			$updatedCompliance = updateCompliance($allc['sr'], $fpr, $approver, $hod, $location, $department);
			if($updatedCompliance == 1){
				insertEditlog('On-going', $old_data, $new_data, $editorid, $editorrole, $allc['company_id'], $allc['compliance_id'], $allc['act_id'], $allc['sr']);
			} else {
				echo "Compliance Editing Failed";
			}
		}
		
		//checking if previous cycles have any ongoing compliance id
		$oldpreComp = getPreParentCompliance($companyid, $prevfpr, $prevappr, $prevhod, $prevloc, $prevdep);
		if(count($oldpreComp) >= 1){ 
			foreach($oldpreComp as $pp){
				$checkifComGenerated = checkpreIfComplianceGenerated($pp['sr'], $companyid, $edcomp, $prevfpr, $prevappr, $prevhod, $prevloc, $prevdep); // checking if any compliances are generated under the cycle or not.
				if($checkifComGenerated == 1){ // if generated
					//deletecomplainces under the cycle.
					$delComp = deleteGenCycleCompliances($pp['sr'], $prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $companyid, $edcomp);
				} else {
					// do nothing
				}		
			}
		}
		
		//checking if the cycles already exists 
		$parentCompliance = getParentCompliance($companyid, $fpr, $approver, $hod, $location, $department);
		if(count($parentCompliance) >= 1){ 
			foreach($parentCompliance as $pp){
				$checkifComGenerated = checkIfComplianceGenerated($pp['sr'], $companyid); // checking if any compliances are generated under the cycle or not.
				if($checkifComGenerated == 1){ // if generated
					//deletecomplainces under the cycle.
					$delComp = deleteCycleCompliances($pp['sr'], $fpr, $approver, $hod, $location, $department, $companyid);
				} else {
					// do nothing
				}		
			}
		} else {		
			//generating new cycles for the updated hierarchy
			$minCycleDate = minCycleDate($prevfpr, $prevappr, $prevhod, $prevdep, $prevloc, $companyid);
			$excludeDate  = getExcludeDate($prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $companyid);
			$pendingDate = getpendingApproverDate($prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $companyid);
			if(!$minCycleDate){
				$min2 = date('Y-m-d', strtotime('2070-12-31'));		
			} else {
				$min2 = date('Y-m-d', strtotime($minCycleDate));
				$min2time = strtotime($minCycleDate);
				$min2month = date("F",$min2time);
				$min2year = date("Y",$min2time);
				for ($date = strtotime($min2); $date < strtotime("30 March +3 year"); $date = strtotime("+80 Day",$date)) {
					$ddddd2 = date('n', $date);
					$ddddd3 = date('Y', $date);
					$current_quarter = ceil($ddddd2 / 3);
					$c30date = date('Y-m-t', strtotime($ddddd3 . '-' . (($current_quarter * 3)) . '-1'));
					$c30time = strtotime($c30date);
					$c30month = date("F",$c30time);
					$c30year = date("Y",$c30time);
					
					if($min2month == $c30month){
						if(in_array($c30date, $excludeDate)){
							
						} else if(in_array($c30date, $pendingDate[0])){
							$element = array_search($c30date, $pendingDate[0]);
							$previouscycle = $pendingDate[1][$element];
							$check = checkCycleinsertOnging($fpr, $approver, $hod, $department, $location, $c30month);//to avoid duplicate 
							if($check == 0){
								$ins = insert_cycle_ccompliance_cron2_new_appr(99998, 556, $companyid, $department, $location , $fpr, $approver, $hod, '10', $c30date);
								updategeneratedcyclewithapproverstatus($ins, $companyid, $edcomp, $prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $fpr, $approver, $hod, $location, $department, $previouscycle);
							}
						} else {
							$check = checkCycleinsertOnging($fpr, $approver, $hod, $department, $location, $c30month);//to avoid duplicate entry of event check cycle
							if($check == 0){
								insert_cycle_ccompliance_cron2_new(99998, 556, $companyid, $department, $location , $fpr, $approver, $hod, '10', $c30date);
							}
							// echo $c30date;
						}
					} else if ($min2 < $c30date){
						if(in_array($c30date, $excludeDate)){
							
						}  else if(in_array($c30date, $pendingDate[0])){
							$element = array_search($c30date, $pendingDate[0]);
							$previouscycle = $pendingDate[1][$element];
							$check = checkCycleinsertOnging($fpr, $approver, $hod, $department, $location, $c30month);//to avoid duplicate 
							if($check == 0){
								$ins = insert_cycle_ccompliance_cron2_new_appr(99998, 556, $companyid, $department, $location , $fpr, $approver, $hod, '10', $c30date);
								updategeneratedcyclewithapproverstatus($ins, $companyid, $edcomp, $prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $fpr, $approver, $hod, $location, $department, $previouscycle);
							}
						} else {
							$check = checkCycleinsertOnging($fpr, $approver, $hod, $department, $location, $c30month);//to avoid duplicate entry of event check cycle
							if($check == 0){
								insert_cycle_ccompliance_cron2_new(99998, 556, $companyid, $department, $location , $fpr, $approver, $hod, '10', $c30date);
							}
							// echo $c30date;
						}
					}
					$date=strtotime($c30date);						
				}
			}
		}		
		// deleteongoinCyclesifNocompliance($prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $companyid);
	}
	return 1;
}

function update_ongoing_compliance_whole($actid, $sr, $edcomp, $prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $fpr, $approver, $hod, $location, $department, $companyid, $editorid, $editorrole){
    $complianceFound = 0;
	$old_data = "FPR:".$prevfpr.",Approver:".$prevappr.",HoD:".$prevhod.",Location:".$prevloc.",Department:".$prevdep;
	$new_data = "FPR:".$fpr.",Approver:".$approver.",HoD:".$hod.",Location:".$location.",Department:".$department;
	$updatedCompliance = updateCompliance($sr, $fpr, $approver, $hod, $location, $department);
	if($updatedCompliance == 1){
		insertEditlog('On-going', $old_data, $new_data, $editorid, $editorrole, $companyid, $edcomp, $actid, $sr);
	} else {
		echo "Compliance Editing Failed";
	}
}

function ongoingFurther($prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $fpr, $approver, $hod, $location, $department){
	$companyid = $_SESSION['company_id'];
	$check = ongoingcompliancesStill($prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $companyid);
	if(count($check) >=1){
		//keep cycles
		//checking if the cycles already exists for new hierarchy
		$parentCompliance = getParentCompliance($companyid, $fpr, $approver, $hod, $location, $department);
		if(count($parentCompliance) >= 1){ 
			foreach($parentCompliance as $pp){
				$checkifComGenerated = checkIfComplianceGenerated($pp['sr'], $companyid); // checking if any compliances are generated under the cycle or not with status !=7 and !=4
				if($checkifComGenerated == 1){ // if generated
					//deletecomplainces under the cycle.
					$delComp = deleteCycleCompliances($pp['sr'], $prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $companyid);
				} else {
					// do nothing
				}		
			}
		} else {		
			//generating new cycles for the updated hierarchy
			$minCycleDate = minCycleDate($prevfpr, $prevappr, $prevhod, $prevdep, $prevloc, $companyid);
			$excludeDate  = getExcludeDate($prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $companyid);
			if(!$minCycleDate){
				$min2 = date('Y-m-d', strtotime('2070-12-31'));		
			} else {
				$min2 = date('Y-m-d', strtotime($minCycleDate));
				$min2time = strtotime($minCycleDate);
				$min2month = date("F",$min2time);
				$min2year = date("Y",$min2time);
				for ($date = strtotime($min2); $date < strtotime("30 March +4 year"); $date = strtotime("+80 Day",$date)) {
					$ddddd2 = date('n', $date);
					$ddddd3 = date('Y', $date);
					$current_quarter = ceil($ddddd2 / 3);
					$c30date = date('Y-m-t', strtotime($ddddd3 . '-' . (($current_quarter * 3)) . '-1'));
					$c30time = strtotime($c30date);
					$c30month = date("F",$c30time);
					$c30year = date("Y",$c30time);
					
					if($min2month == $c30month){
						if(in_array($c30date, $excludeDate)){
						} else {
							$check = checkCycleinsertOnging($fpr, $approver, $hod, $department, $location, $c30month);//to avoid duplicate entry of event check cycle
							if($check == 0){
								insert_cycle_ccompliance_cron2_new(99998, 556, $companyid, $department, $location , $fpr, $approver, $hod, '10', $c30date);
							}
							// echo $c30date;
						}
					} else if ($min2 < $c30date){
						if(in_array($c30date, $excludeDate)){
						} else {
							$check = checkCycleinsertOnging($fpr, $approver, $hod, $department, $location, $c30month);//to avoid duplicate entry of event check cycle
							if($check == 0){
								insert_cycle_ccompliance_cron2_new(99998, 556, $companyid, $department, $location , $fpr, $approver, $hod, '10', $c30date);
							}
									// echo $c30date;
						}
					}
					$date=strtotime($c30date);						
				}
			}
		}
	} else {
		$parentCompliance = getParentCompliance($companyid, $fpr, $approver, $hod, $location, $department);
		if(count($parentCompliance) >= 1){ 
			foreach($parentCompliance as $pp){
				$checkifComGenerated = checkIfComplianceGenerated($pp['sr'], $companyid); // checking if any compliances are generated under the cycle or not with status !=7 and !=4
				if($checkifComGenerated == 1){ // if generated
					//deletecomplainces under the cycle.
					$delComp = deleteCycleCompliances($pp['sr'], $prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $companyid);
				} else {
					// do nothing
				}		
			}
		} else {
			//update the current user's cycles with new data
			$getOngoingCycles = getOngoingCycle($prevfpr, $prevappr, $prevhod, $prevloc, $prevdep);
			foreach($getOngoingCycles as $gt){
				updateOngoingCycle($gt['sr'], $department, $location , $fpr, $approver, $hod);
				updateGeneratedCompliance($gt['sr'], $department, $location , $fpr, $approver, $hod);
			}
		}
	}
	deleteongoinCyclesifNocompliance($prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $companyid);
}
	
function updateOngoingCycle($sr, $department, $location , $fpr, $approver, $hod){
	$company_id = $_SESSION['company_id'];
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("UPDATE `company_compliance` SET `fpr_id`=?,`hod_id`=?,`appr_id`=?,`department`=?,`location`=? WHERE `sr`=?");
		$query->bindValue(1, $fpr);
		$query->bindValue(2, $hod);
		$query->bindValue(3, $approver);
		$query->bindValue(4, $department);
		$query->bindValue(5, $location);
		$query->bindValue(6, $sr);
		$result = $query->execute();
		if($result){ return 1; } else { return 0; }
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function updateGeneratedCompliance($sr, $department, $location , $fpr, $approver, $hod){
	$company_id = $_SESSION['company_id'];
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("UPDATE `company_compliance` SET `fpr_id`=?,`hod_id`=?,`appr_id`=?,`department`=?,`location`=? WHERE `sr`=?");
		$query->bindValue(1, $fpr);
		$query->bindValue(2, $hod);
		$query->bindValue(3, $approver);
		$query->bindValue(4, $department);
		$query->bindValue(5, $location);
		$query->bindValue(6, $sr);
		$result = $query->execute();
		if($result){ return 1; } else { return 0; }
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function getOngoingCycle($prevfpr, $prevappr, $prevhod, $prevloc, $prevdep){
	$company_id = $_SESSION['company_id'];
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `fpr_id`='$prevfpr' AND `appr_id`='$prevappr' AND `hod_id`='$prevhod' AND `location`='$prevloc' AND `department`='$prevdep' AND `cycle_id`=0 AND `act_id`=99998 AND `compliance_id`=556");
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function ongoingcompliancesStill($prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $companyid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT `company_compliance`.* FROM `company_compliance` JOIN `compliance` ON `company_compliance`.`compliance_id`=`compliance`.`id` WHERE `compliance`.`periodicity` LIKE '%going%' AND (`company_compliance`.`status`=1 OR `company_compliance`.`status`=3 OR `company_compliance`.`status`=4 OR `company_compliance`.`status`=6) AND `company_compliance`.`fpr_id`='$prevfpr' AND `company_compliance`.`appr_id`='$prevappr' AND `company_compliance`.`hod_id`='$prevhod' AND `company_compliance`.`location`='$prevloc' AND `company_compliance`.`department`='$prevdep' AND `cycle_id`=0");
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function deleteOngoingCycle($prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $companyid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("DELETE FROM `company_compliance` WHERE `company_id`=? AND `act_id`=? AND `status` !=? AND `fpr_id`=? AND `appr_id`=? AND `hod_id`=? AND `location`=? AND `department`=?");
		$query->bindValue( 1, $companyid );
		$query->bindValue( 2, 99998 );
		$query->bindValue( 3, 7 );
		$query->bindValue( 4, $prevfpr );
		$query->bindValue( 5, $prevappr );
		$query->bindValue( 6, $prevhod );
		$query->bindValue( 7, $prevloc );
		$query->bindValue( 8, $prevdep );
		$result = $query->execute();
		if($result){ return 1; } else { return 0; }
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function deleteongoinCyclesifNocompliance($prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $companyid){
	$check = ongoingcompliancesStill($prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $companyid);
	if(count($check) >=1){
		return 1;
		//keep cycles
	} else {
		$deleteCyclesOngoing = deleteOngoingCycle($prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $companyid);
		$deleteCyclesOngoing = 1;
		if($deleteCyclesOngoing == 1){
			return 1;
		} else {
			return 0;
		}
	}
}
?>